<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\FactUnit\Domain\IdFactUnit;

class FactUnitMother
{

    public static function pushDefault()
    {
        return self::push(self::build1(IdFactUnit::defaultValue()));
    }
    
    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactUnit' => $id,
            'FactUnit_Name' => $faker->text(rand(5, 100)),
            'FactUnit_Abrv' => Util::generateString(10),
            'FactUnit_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_unit`(`Id_FactUnit`,`FactUnit_Name`, `FactUnit_Abrv`, `FactUnit_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactUnit'] == 0 ? null : $object['Id_FactUnit'],
            $object['FactUnit_Name'],
            $object['FactUnit_Abrv'],
            $object['FactUnit_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactUnit'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::FACT_UNIT ];
    }
}
