<?php

namespace App\DBRealTestSupport\Booking;

use App\DBRealTestSupport\Booking\Data\DataBooking;
use App\DBRealTestSupport\BookingMother;
use App\DBRealTestSupport\CategoryTourMother;
use App\DBRealTestSupport\LanguageMother;
use App\DBRealTestSupport\TypeDocumentMother;
use App\DBRealTestSupport\TypeRateMother;
use App\DBRealTestSupport\TypeTourMother;
use App\DBRealTestSupport\UserCountryMother;
use App\DBRealTestSupport\UserMother;
use App\Modules\Booking\Domain\BookingInPerson;
use App\Modules\Booking\Domain\BookingLastMinute;
use App\Modules\Booking\Domain\BookingManuallyConfirmed;
use App\Modules\Booking\Domain\BookingReceipt;
use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\Booking\Domain\BookingType;
use DateTime;

class TestBookingBuilder
{
    private BookingBasicData $data;

    public function init()
    {
        BookingMother::init();
        LanguageMother::pushBasicDefault();
        BookingMother::pushRelationshipAndReferredFrom();
    }

    public function required()
    {
        $typeDocument = TypeDocumentMother::push1();
        $userCountry = UserCountryMother::push1();
        $this->data = new BookingBasicData(
            Id_Language: LanguageMother::pushBasic()['Id_Language'],
            Id_GuideLanguage: LanguageMother::pushBasic()['Id_Language'],
            Id_TypeDocument: $typeDocument['Id_TypeDocument'],
            Id_UserCountry: $userCountry['Id_UserCountry'],
            Id_User: UserMother::push1($typeDocument['Id_TypeDocument'], $userCountry['Id_UserCountry'])['Id_User'],
            Id_CategoryTour: CategoryTourMother::push1()['Id_CategoryTour'],
            Id_TypeTour: TypeTourMother::push1()['Id_TypeTour'],
            Id_TypeRate: TypeRateMother::push1()['Id_TypeRate'],
        );
        return $this->data;
    }

    public function addPax()
    {
    }

    public function build($Id_Admin, BookingBasicData $data)
    {
        return new DataBooking(
            Id_Booking: 0,
            Booking_Date: new DateTime('now'),
            Booking_DateConfirm: new DateTime('now'),
            Booking_DateStart: new DateTime('now'),
            Booking_DateBriefing: new DateTime('now'),
            Booking_PlaceBriefing: '',
            Booking_Code: '',
            Booking_HistoryChanges: '',
            Booking_Hotel: '',
            Booking_Observation: '',
            Booking_InternalRemark: '',
            Booking_Receipt: BookingReceipt::ANSWER_NO,
            Booking_Type: BookingType::RESERVA_WEB,
            Booking_LastMinute: BookingLastMinute::NORMAL,
            Booking_Assigned: 0,
            Booking_Status: BookingStatus::PENDING,
            Booking_ManuallyConfirmed: BookingManuallyConfirmed::VALUE_FALSE,
            Booking_InPerson: BookingInPerson::BOOKING_TYPE,
            Booking_PassengerAmount: 0,
            Booking_CheckedInPassengers: 0,
            Booking_LastPassenger: 0,
            Booking_Token: '',
            Id_Booking_Replace: 0,
            Id_Admin: $Id_Admin,
            Id_GuideLanguage: $data->Id_GuideLanguage,
            Id_Language: $data->Id_Language,
            Id_User: $data->Id_User,
            Id_User_Additional: 0,
            Id_BookingRelationship: 1,
            Id_BookingReferredFrom: 1,
        );
    }
}
