<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\TourHtlCamp\Domain\TourHtlCampRepository;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;

$app->bind(TourHtlCampRepository::class, fn($app) => $app->make(MysqlTourHtlCampRepository::class));

$router->post(
    '/tourHtlCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TourhtlCamp\\TourHtlCampInsertController@__invoke'
    ]
);

$router->put(
    '/tourHtlCamp',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TourHtlCamp\\TourHtlCampUpdateController@__invoke'
    ]
);

$router->delete(
    '/tourHtlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TourHtlCamp\\TourHtlCampDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/tourHtlCamp/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TourHtlCamp\\TourHtlCampIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/tour/{Id_Tour}/tourHtlCamp/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TourHtlCamp\\TourHtlCampListController@__invoke'
    ]
)->where('Id_Tour', '[0-9]*');
