<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;
use App\Modules\QuestionTypeProvider\Infraestructure\MysqlQuestionTypeProviderRepository;

$app->bind(QuestionTypeProviderRepository::class, fn($app) => $app->make(MysqlQuestionTypeProviderRepository::class));

$router->post(
    '/questionTypeProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'QuestionTypeProvider\\QuestionTypeProviderInsertController@__invoke'
    ]
);
$router->put(
    '/questionTypeProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'QuestionTypeProvider\\QuestionTypeProviderUpdateController@__invoke'
    ]
);
$router->delete(
    '/questionTypeProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'QuestionTypeProvider\\QuestionTypeProviderDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/questionTypeProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'QuestionTypeProvider\\QuestionTypeProviderIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/question/{IdQuestion}/questionTypeProvider/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'QuestionTypeProvider\\QuestionTypeProviderListController@__invoke'
    ]
)->where('IdQuestion', '[0-9]*');
