<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Passenger\Domain\PassengerRepository;
use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Passenger\Infraestructure\MysqlPassengerRepository;
use App\Modules\Passenger\Infraestructure\MysqlPassengerSearchWithReviewRepository;


$app->bind(
    PassengerSearchWithReviewRepository::class,
    fn($app) => $app->make(MysqlPassengerSearchWithReviewRepository::class)
);
$app->bind(
    PassengerRepository::class,
    fn($app) => $app->make(MysqlPassengerRepository::class)
);

$router->delete(
    '/passenger/{IdPassenger}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Passenger\\PassengerRemoveController@__invoke'
    ]
)->where('IdPassenger', '[0-9]*');

$router->post(
    '/passenger/{IdPassenger}/enable',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Passenger\\PassengerEnableController@__invoke'
    ]
)->where('IdPassenger', '[0-9]*');

$router->post(
    '/passenger/{Id}/confirm',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Passenger\\PassengerConfirmController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->post(
    '/passenger/{Id}/deny',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Passenger\\PassengerDenyController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/passenger/passengerReviewReportExternal/excel',
    [
        'uses' => 'Passenger\\QueryExcelReviewReportController@__invoke'
    ]
);

$router->get(
    '/passenger/passengerReviewReportExternal/excelData',
    [
        'uses' => 'Passenger\\DataQueryReviewReportController@__invoke'
    ]
);

$router->put(
    '/passenger/reportable',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Passenger\\PassengerReportablePutController@__invoke'
    ]
);