<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Infrastructure\MysqlHtlCampBookingPassengerRepository;

$app->bind(HtlCampBookingPassengerRepository::class, fn ($app) => $app->make(MysqlHtlCampBookingPassengerRepository::class));

$router->get(
    '/htlCampBooking/{Id_HtlCampBooking}/htlCampBookingPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerListController@__invoke'
    ]
)->where('Id_HtlCampBooking', '[0-9]*');

$router->get(
    '/htlCampBookingPassenger/{Id_HtlCampBookingPassenger}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerIndexController@__invoke'
    ]
)->where('Id_HtlCampBookingPassenger', '[0-9]*');

$router->get(
    '/htlCampBookingPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerListByScheduleController@__invoke'
    ]
);

$router->post(
    '/htlCampBookingPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerInsertController@__invoke'
    ]
);

$router->put(
    '/htlCampBookingPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/htlCampBookingPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBookingPassenger\\HtlCampBookingPassengerDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
