<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Group\Domain\GroupRepository;
use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Group\Infraestructure\MysqlGroupRepository;
use App\Modules\Group\Infraestructure\MysqlGroupRepositoryAlter;

$app->bind(GroupRepositoryAlter::class, fn ($app) => $app->make(MysqlGroupRepositoryAlter::class));
$app->bind(GroupRepository::class, fn ($app) => $app->make(MysqlGroupRepository::class));

$router->get(
    '/group/reviewToken',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@GenerateReviewLink'
    ]
);
$router->get(
    '/group/groupReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\ReviewList@__invoke'
    ]
);

$router->post(
    '/group',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Insert'
    ]
);
$router->post(
    '/group/full',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Insert_Full'
    ]
);
$router->put(
    '/group',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Update'
    ]
);
$router->put(
    '/group/remark',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Remark'
    ]
);
$router->put(
    '/group/status',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Status'
    ]
);
$router->delete(
    '/group/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Delete'
    ]
);

$router->get(
    '/group/programming/{action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\GroupProgrammingListController@__invoke'
    ]
);

$router->get(
    '/group/programming/{action}/excel',
    [
        'uses' => 'Group\\GroupProgrammingExcelListController@__invoke'
    ]
);

$router->post(
    '/group/{Id}/copyProviders',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\GroupCopyProvidersController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/group/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Selector'
    ]
);


$router->get(
    '/group/search/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Search_Passenger'
    ]
);
$router->get(
    '/group/search/providerPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\ProviderPassenger@__invoke'
    ]
);

$router->get(
    '/group/report/paginated',
    [
        'uses' => 'Group@Report_Paginated'
    ]
);
$router->get(
    '/group/report/unitary',
    [
        'uses' => 'Group@reportUnitary'
    ]
);

$router->get(
    '/group/report/excel',
    [
        'uses' => 'Group@Report_Excel'
    ]
);
$router->get(
    '/group/report/unitary/excel',
    [
        'uses' => 'Group@Report_Excel_Group'
    ]
);
$router->get(
    '/group/{Id}/review/excel',
    [
        'uses' => 'Group@Report_Excel_Review'
    ]
);

$router->get(
    '/group/report/pdf',
    [
        'uses' => 'Group@Report_Group_List_Pdf'
    ]
);
$router->get(
    '/group/report/unitary/pdf',
    [
        'uses' => 'Group@Report_Group_Pdf'
    ]
);
$router->get(
    '/group/{Id}/review/pdf',
    [
        'uses' => 'Group@Report_Group_Review_Pdf'
    ]
);
$router->get(
    '/group/{Id}/mail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Send_Review_Mail'
    ]
);

$router->post(
    '/group/slave/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_Insert_All'
    ]
);
$router->post(
    '/group/slave',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_Insert'
    ]
);
$router->delete(
    '/group/slave/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_Delete'
    ]
);
$router->get(
    '/group/{Id}/slave',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_List'
    ]
);
$router->get(
    '/group/{Id}/slaveAll',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_List_Complete'
    ]
);
$router->get(
    '/group/{Id}/slave/search',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group@Slave_Search'
    ]
);
