<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailRepository;
use App\Modules\FactReceiptDetail\Infraestructure\MysqlFactReceiptDetailRepository;

$app->bind(FactReceiptDetailRepository::class, fn ($app) => $app->make(MysqlFactReceiptDetailRepository::class));

$router->post(
    '/factReceiptDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceiptDetail\\FactReceiptDetailInsertController@__invoke'
    ]
);

$router->put(
    '/factReceiptDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceiptDetail\\FactReceiptDetailUpdateController@__invoke'
    ]
);

$router->get(
    '/factReceiptDetail/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceiptDetail\\FactReceiptDetailIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->delete(
    '/factReceiptDetail/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceiptDetail\\FactReceiptDetailDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factReceipt/{IdFactReceipt}/factReceiptDetail/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceiptDetail\\FactReceiptDetailListController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
