<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalUserPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerInsertController@__invoke'
    ]
);

$router->put(
    '/externalUserPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalUserPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalUserPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    'externalUser/{IdExternalUser}/externalUserPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUserPassenger\\ExternalUserPassengerListController@__invoke'
    ]
)->where('IdExternalUser', '[0-9]*');
