<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/external',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'External\\ExternalInsertController@__invoke'
    ]
);

$router->put(
    '/external',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'External\\ExternalUpdateController@__invoke'
    ]
);

$router->delete(
    '/external/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'External\\ExternalDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/external/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'External\\ExternalIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/external/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'External\\ExternalListController@__invoke'
    ]
);
