<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;
use App\Modules\CashMovementFactReceipt\Infraestructure\MysqlCashMovementFactReceiptRepository;

$app->bind(CashMovementFactReceiptRepository::class, fn($app) => $app->make(MysqlCashMovementFactReceiptRepository::class));

$router->post(
    '/cashMovement/{idCashMovement}/factReceipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementFactReceipt\\CashMovementFactReceiptCreateController@__invoke'
    ]
)->where(['idCashMovement' => '[0-9]*']);

$router->put(
    '/cashMovementFactReceipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementFactReceipt\\CashMovementFactReceiptUpdateController@__invoke'
    ]
);

$router->get(
    '/cashMovementFactReceipt/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementFactReceipt\\CashMovementFactReceiptIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/cashMovement/{IdCashMovement}/cashMovementFactReceipt/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementFactReceipt\\CashMovementFactReceiptListController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
