<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingTour\Domain\BookingTourPassengerListRepository;
use App\Modules\BookingTour\Domain\BookingTourRepository;
use App\Modules\BookingTour\Infraestructure\MysqlBookingTourPassengerListRepository;
use App\Modules\BookingTour\Infraestructure\MysqlBookingTourRepository;

$app->bind(BookingTourRepository::class, fn($app) => $app->make(MysqlBookingTourRepository::class));
$app->bind(BookingTourPassengerListRepository::class, fn($app) => $app->make(MysqlBookingTourPassengerListRepository::class));

$router->put(
    '/bookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@update'
    ]
);

$router->get(
    '/bookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@index'
    ]
);

$router->post(
    '/bookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@addPackage'
    ]
);

$router->put(
    '/bookingTour/change',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour\\BookingTourChangeController@__invoke'
    ]
);

$router->get(
    '/bookingTour/{Id}/report',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@Report'
    ]
);

$router->delete(
    '/bookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@Delete'
    ]
);

$router->put(
    '/bookingTour/{Id}/enable',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour@Enable'
    ]
);
