<?php

namespace App\Tasks\Media;

use App\Modules\GroupProvider\Application\DeleteMedia\DeleteMediaGroupProviderQuery;
use App\Modules\GroupProvider\Application\GroupProviderResponses;
use App\Modules\GroupProvider\Application\ListForDelete\ListForDeleteGroupProviderQuery;
use App\Modules\GroupProvider\Application\UpdateStatus\UpdateStatusGroupProviderQuery;
use App\Modules\GroupProvider\Domain\GroupProviderMediaStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class DeleteGroupProviderMedia
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke()
    {
        try {
            /** @var GroupProviderResponses $response */
            $response = $this->queryBus->ask(new ListForDeleteGroupProviderQuery());

            foreach ($response->data() as $groupProvider) {
                $this->queryBus->ask(new DeleteMediaGroupProviderQuery($groupProvider->Id_GroupProvider));
                $this->queryBus->ask(new UpdateStatusGroupProviderQuery($groupProvider->Id_GroupProvider, GroupProviderMediaStatus::DELETED));
            }
        } catch (\Throwable $th) {
            dd($th);
        }
    }
}
