<?php

namespace App\Providers\ExcelProviderServiceReport;

class ProviderServiceGroupDto
{

  public function __construct(
    public int $Id_Group,
    public string $Group_DateStart,
    public string $Group_DateEnd,
    public string $Group_Name,
    public int $Group_Type,
    public int $Group_TourDuration,
    public int $Group_Status,
    public int $Group_MasterType,
    public int $Cant_Pax_Review,
    public int $Cant_Pax,
    public string $Service_Code,
    public string $Service_Name,
    public string $Group_Endorser,
    public string $Tour_Color,
    public int $Id_Provider,
    public string $Provider_BusinessName,
    public string $Provider_TradeName,
    public string $Provider_NickName,
    public string $Provider_NoDocument,
    public string $Provider_Address,
    public string $Provider_Phone,
    public string $Provider_ImgProfile,
    public string $Provider_ImgProfile_Thumb,
    public int $Provider_Status,
    public int $Provider_ScoreTotal,
    public int $Provider_ScoreCant,
    public int $Type_Report,
    public int $Id,
    public int $GroupPassenger_PassengerCount,
    public int $Id_TypeProvider,
    public string $TypeProvider_Name,
    /** @var array<ProviderServiceProviderDto> */
    public array $Providers,
    /** @var array<ProviderServicePassengerDto> */
    public array $Passenger,
  ) {
  }

  public static function fromDTO($data)
  {
    return new self(
      $data->Id_Group,
      $data->Group_DateStart,
      $data->Group_DateEnd,
      $data->Group_Name,
      $data->Group_Type,
      $data->Group_TourDuration,
      $data->Group_Status,
      $data->Group_MasterType,
      $data->Cant_Pax_Review,
      $data->Cant_Pax,
      $data->Service_Code,
      $data->Service_Name,
      $data->Group_Endorser,
      $data->Tour_Color,
      $data->Id_Provider,
      $data->Provider_BusinessName,
      $data->Provider_TradeName,
      $data->Provider_NickName,
      $data->Provider_NoDocument,
      $data->Provider_Address,
      $data->Provider_Phone,
      $data->Provider_ImgProfile,
      $data->Provider_ImgProfile_Thumb,
      $data->Provider_Status,
      $data->Provider_ScoreTotal,
      $data->Provider_ScoreCant,
      $data->Type_Report,
      $data->Id,
      $data->GroupPassenger_PassengerCount,
      $data->Id_TypeProvider,
      $data->TypeProvider_Name,
      array_map([ProviderServiceProviderDto::class, 'fromDTO'], json_decode($data->Providers)),
      array_map([ProviderServicePassengerDto::class, 'fromDTO'], $data->Passenger)
    );
  }
}
