<?php

namespace App\Providers\ExcelGroupProgramming;

use App\Modules\TypeProvider\Domain\IdTypeProvider;
use App\Providers\ExcelReport\Utils;

class ExcelGroupProgrammingCells
{

    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($providerColumns, $data)
    {
        return array_map(fn ($group) => $this->getRow($providerColumns, $group), $data);
    }

    private function groupMasterType($groupMasterType)
    {
        if ($groupMasterType == 0) {
            return '';
        }
        if ($groupMasterType == 1) {
            return 'E';
        }
        if ($groupMasterType == 2) {
            return 'M';
        }
    }

    private function groupType($group)
    {
        if ($group->Group_ServiceType == 1) {
            return $group->Group_Type == 1 ? 'R' : 'P';
        }
        if ($group->Group_ServiceType == 2) {
            return 'A';
        }
        if ($group->Group_ServiceType == 3) {
            return 'TI';
        }
        if ($group->Group_ServiceType == 4) {
            return 'TO';
        }
    }

    private function showProvider($Id_TypeProvider)
    {
        return fn ($group) => $this->convertProvider(array_filter($group->Group_Providers, fn ($gp) => $gp->Id_TypeProvider == $Id_TypeProvider));
    }

    private function showProviderRemark($Id_TypeProvider)
    {
        return fn ($group) => $this->convertRemark(array_filter($group->Group_Providers, fn ($gp) => $gp->Id_TypeProvider == $Id_TypeProvider));
    }

    private function convertProvider($providers)
    {
        if (count($providers)) {
            return implode(
                "\n",
                array_map(
                    fn ($p) => "- {$p->Provider_NickName}",
                    $providers
                ),
            );
        } else {
            return '';
        }
    }

    private function convertRemark($providers)
    {
        if (count($providers)) {
            return implode(
                "\n",
                array_map(
                    fn ($p) => $p->GroupProvider_Remark,
                    $providers
                ),
            );
        } else {
            return '';
        }
    }

    private function getRow($providerColumns, $group)
    {
        return array_merge(
            array_merge(
                [
                    $this->tableCellLeft($group->BookingTour_DateStart),
                    $this->tableCellCenter($group->Id_Group ? $this->groupMasterType($group->Group_MasterType) : ''),
                    $this->tableCellLeft($group->Id_Group ? $this->groupType($group) : ''),
                    $this->tableCellLeft($group->Group_ServiceType == 1 || $group->Group_ServiceType == 2 ? $group->Tour_Name : ''),
                    $this->tableCellLeft($group->Id_Group ? $group->Group_Name : $group->Tour_Name),
                    $this->tableCellCenter($group->Passenger_Amount),
                ],
                $this->generateGroupProviderFromProviders($providerColumns, $group),
                [
                    $this->tableCellLeft($group->Group_Remark),
                ]
            )
        );
    }

    private function generateGroupProviderFromProviders($providerColumns, $group)
    {
        return array_merge(...array_map(
            fn ($provider) => $provider->Id_TypeProvider !== IdTypeProvider::HORSE_MAN ?
                [$this->tableCellLeft($group->Id_Group ? $this->showProvider($provider->Id_TypeProvider)($group) : '')] :
                [
                    $this->tableCellLeft($group->Id_Group ? $this->showProvider($provider->Id_TypeProvider)($group) : ''),
                    $this->tableCellLeft($group->Id_Group ? $this->showProviderRemark($provider->Id_TypeProvider)($group) : '')
                ],
            $providerColumns
        ));
    }

    private function generateHeadersFromProviders($providerColumns)
    {
        return array_merge(...array_map(
            fn ($provider) => $provider->Id_TypeProvider !== IdTypeProvider::HORSE_MAN ?
                [[
                    $provider->title,
                    28
                ]] :
                [
                    [
                        $provider->title,
                        28
                    ],
                    [
                        '',
                        24
                    ]
                ],
                $providerColumns
        ));
    }

    public function run($data, $metadata)
    {
        usort($data->ProviderColumns, fn($a, $b) => $a->Id_TypeProvider - $b->Id_TypeProvider);
        return array_merge(
            [
                array_merge(
                    array_map(
                        [$this, 'tableTitle'],
                        array_merge(
                            [
                                ['SALIDA', 10],
                                ['M', 4],
                                ['T', 4],
                                ['TOUR', 30],
                                ['', 35],
                                ['PAX', 6],
                            ],
                            $this->generateHeadersFromProviders($data->ProviderColumns),
                            [
                                ['OBSERVACIONES', 100]
                            ]
                        )
                    ),
                ),
            ],
            $this->getAllRows($data->ProviderColumns, $data->Tours)
        );
    }
}
