<?php

namespace App\Modules\WebContactMessageDetail\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateWebContactMessageDetailQuery implements Query
{
    public function __construct(
        private int $id,
        private string $dateStart,
        private string $package,
        private int $status,
        private int $idWebContactMessage,
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function package(): string
    {
        return $this->package;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function id(): string
    {
        return $this->id;
    }

    public function idWebContactMessage(): int
    {
        return $this->idWebContactMessage;
    }
}
