<?php

namespace App\Modules\WebContactMessageDetail\Application\Delete;

use App\Modules\WebContactMessageDetail\Application\Delete\WebContactMessageDetailDeleterResponse;
use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;

final class WebContactMessageDetailDeleter
{
    public function __construct(private WebContactMessageDetailRepository $repository)
    {
    }

    public function __invoke(IdWebContactMessageDetail $idWebContactMessageDetail): DeleteWebContactMessageDetailQueryResponse
    {
        return new DeleteWebContactMessageDetailQueryResponse($this->repository->delete($idWebContactMessageDetail));
    }
}
