<?php

namespace App\Modules\WebContactMessage\Infraestructure;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\WebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessage\Domain\UpdateWebContactMessage;

class MysqlWebContactMessageRepository implements WebContactMessageRepository
{

    public function find(IdWebContact $idWebContact, string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_message_list(?,?,@sts,@cod,@msg)',
            [
                $idWebContact->value(),
                $action
            ]
        );
    }

    public function findAll(DateStart $dateStart, DateEnd $dateEnd, string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_message_list_all(?,?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value(),
                $action
            ]
        );
    }

    public function index(IdWebContactMessage $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_message_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(WebContactMessage $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_web_contact_message_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->dateDeparture()->value(),
                $value->dateSend()->value(),
                $value->dateReception()->value(),
                $value->name()->value(),
                $value->lastName()->value(),
                $value->email()->value(),
                $value->country()->value(),
                $value->countryCurrent()->value(),
                $value->phoneCode()->value(),
                $value->phone()->value(),
                $value->idCountry()->value(),
                $value->idCountryCurrent()->value(),

                $value->message()->value(),
                $value->adults()->value(),
                $value->children()->value(),
                $value->subscription()->value(),
                $value->origin()->value(),
                $value->type()->value(),
                $value->status()->value(),
                $value->idWebContact()->value(),
                $value->idLanguage()->value(),
            ]
        );
    }

    public function update(UpdateWebContactMessage $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_message_update(?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->message()->value(),
                $value->adults()->value(),
                $value->children()->value(),
                $value->children()->value(),
                $value->status()->value(),
                $value->idWebContact()->value(),
            ]
        );
    }

    public function delete(IdWebContactMessage $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_message_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
