<?php

namespace App\Modules\WebContactMessage\Application\ListAll;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListAllWebContactMessageQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
        private string $action
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }

    public function action(): string
    {
        return $this->action;
    }
}
