<?php

namespace App\Modules\TypeBookingAssign\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignRepository;
use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;

class MysqlTypeBookingAssignRepository implements TypeBookingAssignRepository
{

    public function find(string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_type_booking_assign_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdTypeBookingAssign $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_type_booking_assign_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(TypeBookingAssign $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_type_booking_assign_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->score()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function update(TypeBookingAssign $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_type_booking_assign_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->score()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdTypeBookingAssign $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_type_booking_assign_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
