<?php

namespace App\Modules\TypeBookingAssign\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateTypeBookingAssignQuery implements Query
{
    public function __construct(
        private string $name,
        private string $abrv,
        private int $score,
        private int $status,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }
    public function abrv(): string
    {
        return $this->abrv;
    }
    public function score(): int
    {
        return $this->score;
    }
    public function status(): int
    {
        return $this->status;
    }
}
