<?php

namespace App\Modules\TourQuestion\Domain;

use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\Question\Domain\IdQuestion;
use App\Modules\Question\Domain\QuestionAbrv;
use App\Modules\Question\Domain\QuestionName;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

class RichTourQuestion extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdTourQuestion::class, 'Id_TourQuestion', 'primary'),
            new AggregateAttribute('order', TourQuestionOrder::class, 'TourQuestion_Order'),
            new AggregateAttribute('idTour', IdTour::class, 'Id_Tour'),
            new AggregateAttribute('idQuestion', IdQuestion::class, 'Id_Question'),
            new AggregateAttribute('questionName', QuestionName::class, 'Question_Name'),
            new AggregateAttribute('questionAbrv', QuestionAbrv::class, 'Question_Abrv'),
            new AggregateAttribute('idTypeProvider', IdTypeProvider::class, 'Id_TypeProvider'),
            new AggregateAttribute('QuestionTypeProviderJSON', QuestionTypeProviderJSON::class, 'QuestionTypeProviderJSON'),
        ];
    }

    public static function table(): string
    {
        return 't_tour_question';
    }

    public function __construct(
        protected IdTourQuestion $id,
        protected TourQuestionOrder $order,
        protected IdTour $idTour,
        protected IdQuestion $idQuestion,
        protected QuestionName $questionName,
        protected QuestionAbrv $questionAbrv,
        protected IdTypeProvider $idTypeProvider,
        protected QuestionTypeProviderJSON $QuestionTypeProviderJSON,
    ) {
    }

    public function id(): IdTourQuestion
    {
        return $this->id;
    }

    public function order(): TourQuestionOrder
    {
        return $this->order;
    }

    public function idTour(): IdTour
    {
        return $this->idTour;
    }

    public function idQuestion(): IdQuestion
    {
        return $this->idQuestion;
    }

    public function questionName(): QuestionName
    {
        return $this->questionName;
    }

    public function questionAbrv(): QuestionAbrv
    {
        return $this->questionAbrv;
    }

    public function idTypeProvider(): IdTypeProvider
    {
        return $this->idTypeProvider;
    }

    public function QuestionTypeProviderJSON(): QuestionTypeProviderJSON
    {
        return $this->QuestionTypeProviderJSON;
    }
}
