<?php

namespace App\Modules\Tour\Application\Update;

use App\Modules\Tour\Application\Update\TourUpdaterResponse;
use App\Modules\Tour\Domain\Tour;
use App\Modules\Tour\Domain\TourRepository;

final class TourUpdater
{
    public function __construct(private TourRepository $repository)
    {
    }

    public function __invoke(Tour $tour): TourUpdaterResponse
    {
        return new TourUpdaterResponse($this->repository->update($tour));
    }
}
