<?php

namespace App\Modules\StatusGroupProvider\Application\Update;

use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderName;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderAbrv;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderColor;

final class UpdateStatusGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupProviderUpdater $updater)
    {
    }

    public function __invoke(UpdateStatusGroupProviderQuery $query): UpdateStatusGroupProviderQueryResponse
    {
        $model = new StatusGroupProvider(
            new StatusGroupProviderName($query->name()),
            new StatusGroupProviderAbrv($query->abrev()),
            new StatusGroupProviderColor($query->color()),
            new StatusGroupProviderStatus($query->status()),
            new IdStatusGroupProvider($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
