<?php

namespace App\Modules\StatusGroup\Application\Create;

use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupColor;
use App\Modules\StatusGroup\Domain\StatusGroupAbrv;
use App\Modules\StatusGroup\Domain\StatusGroupName;
use App\Modules\StatusGroup\Domain\StatusGroupStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateStatusGroupQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupCreator $inserter)
    {
    }

    public function __invoke(CreateStatusGroupQuery $query): CreateStatusGroupResponse
    {
        $model = new StatusGroup(
            new StatusGroupName($query->name()),
            new StatusGroupAbrv($query->abrev()),
            new StatusGroupColor($query->color()),
            new StatusGroupStatus($query->status()),
        );
        return $this->inserter->__invoke($model);
    }
}
