<?php

namespace App\Modules\Shared\Validator\Infraestructure;

use App\Http\Helpers\ParamsValidator;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Exceptions\ValidateException;
use Illuminate\Http\Request;

class LaravelValidator
{

    public function __construct()
    {
    }

    public function validate($data, $domain, array $rules)
    {
        $oResponse = ParamsValidator::Validate_Data($data, $rules, $domain);
        if ($oResponse['Response_Code'] != 200) {
            throw new ValidateException($oResponse);
        }
    }

    public static function request(Request $request, $domain, array $rules)
    {
        return (new LaravelValidator)->validate($request->all(), $domain, $rules);
    }
}
