<?php

declare(strict_types=1);

namespace App\Modules\Shared\Domain\ValueObject;

use InvalidArgumentException;
use Ramsey\Uuid\Uuid as RamseyUuid;
use Stringable;

class Uuid implements Stringable {

    protected string $value;

    public function __construct(string $value) {
        $this->value = $value;
        $this->ensureIsValidUuid($value);
    }

    public static function random(): self {
        return new static(RamseyUuid::uuid4()->toString());
    }

    public function value(): string { return $this->value; }

    public function equals(Uuid $other): bool {
        return $this->value() === $other->value();
    }

    public function __toString(): string {
        return $this->value();
    }

    private function ensureIsValidUuid(string $id): void {
        if (!RamseyUuid::isValid($id)) {
            throw new InvalidArgumentException(sprintf('<%s> does not allow the value <%s>.', static::class, $id));
        }
    }
}
