<?php

namespace App\Modules\Shared\Domain\QueryList;

class QueryPaginate
{

    private int $offset;
    private int $limit;
    private bool $paginated = true;

    public function __construct(
        ?string $page,
        ?string $pageSize
    ) {
        if (!is_numeric($page) || !is_numeric($pageSize)) {
            $this->paginated = false;
        }
        $currPage =  max(1, floor($page));
        $currAmount = max(0, floor($pageSize));

        $this->offset = ($currPage - 1) * $currAmount;
        $this->limit = $currAmount;
    }

    public static function fromData(?string $offset, ?string $limit)
    {
        return new QueryPaginate($offset, $limit);
    }

    public function isPaginated(): bool
    {
        return $this->paginated;
    }

    public function getOffset(): int
    {
        return $this->offset;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }
}
