<?php

namespace App\Modules\ReviewNotification\Application\Index;

use App\Modules\ReviewNotification\Application\Index\ReviewNotificationIndexerResponse;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationIndexer
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(IdReviewNotification $idReviewNotification): ReviewNotificationIndexerResponse
    {
        return new ReviewNotificationIndexerResponse($this->repository->index($idReviewNotification));
    }
}
