<?php

namespace App\Modules\Redistribution\Domain;

use App\Modules\Admin\Domain\IdAdmin;

class CreateRedistribution
{

    private RedistributionAmount $amount;
    private RedistributionCurrency $currency;
    private RedistributionRemark $remark;
    private RedistributionStatus $status;
    private IdAdmin $idAdmin;
    private InvoiceDataCollection $invoices;

    public function __construct(
        RedistributionAmount $amount,
        RedistributionCurrency $currency,
        RedistributionRemark $remark,
        RedistributionStatus $status,
        IdAdmin $idAdmin,
        InvoiceDataCollection $invoices
    ) {
        $this->amount = $amount;
        $this->currency = $currency;
        $this->remark = $remark;
        $this->status = $status;
        $this->idAdmin = $idAdmin;
        $this->invoices = $invoices;
    }

    public function amount(): RedistributionAmount
    {
        return $this->amount;
    }
    public function currency(): RedistributionCurrency
    {
        return $this->currency;
    }
    public function remark(): RedistributionRemark
    {
        return $this->remark;
    }
    public function status(): RedistributionStatus
    {
        return $this->status;
    }
    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    /**
     * @return InvoiceData[]
     */
    public function invoices(): InvoiceDataCollection
    {
        return $this->invoices;
    }
}
