<?php

namespace App\Modules\QuestionTypeProvider\Application\Update;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderForPassenger;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderShow;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

final class QuestionTypeProviderUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private QuestionTypeProviderUpdater $updater)
    {
    }

    public function __invoke(QuestionTypeProviderUpdaterQuery $query): QuestionTypeProviderUpdaterResponse
    {
        $model = new QuestionTypeProvider(
            new QuestionTypeProviderShow($query->show()),
            new QuestionTypeProviderForPassenger($query->forPassenger()),
            new QuestionTypeProviderStatus($query->status()),
            new IdProvider($query->idProvider()),
            new IdTypeProvider($query->idTypeProvider()),
            new IdQuestionTypeProvider($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
