<?php

namespace App\Modules\QuestionTypeProvider\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class QuestionTypeProviderUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private int $show,
        private int $forPassenger,
        private int $status,
        private int $idProvider,
        private int $idTypeProvider
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }
    public function show(): int
    {
        return $this->show;
    }
    public function forPassenger(): int
    {
        return $this->forPassenger;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idProvider(): int
    {
        return $this->idProvider;
    }
    public function idTypeProvider(): int
    {
        return $this->idTypeProvider;
    }
}
