<?php

namespace App\Modules\QuestionTypeProvider\Application\Index;

use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class QuestionTypeProviderIndexerQueryHandler implements QueryHandler
{
    public function __construct(private QuestionTypeProviderIndexer $inserter)
    {
    }

    public function __invoke(QuestionTypeProviderIndexerQuery $query): QuestionTypeProviderIndexerResponse
    {
        return $this->inserter->__invoke(new IdQuestionTypeProvider($query->getId()));
    }
}
