<?php

namespace App\Modules\ProviderTypeProvider\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\ProviderTypeProvider\Application\List\ProviderTypeProviderListerResponse;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;

final class ProviderTypeProviderLister
{
    public function __construct(private ProviderTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdLeadBooking $idLeadBooking, string $action): ProviderTypeProviderListerResponse
    {
        return new ProviderTypeProviderListerResponse($this->repository->find($idLeadBooking, $action));
    }
}
