<?php

namespace App\Modules\ProviderSanction\Application\List;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderSanction\Application\List\ProviderSanctionListerResponse;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRepository;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class ProviderSanctionLister
{
    public function __construct(private ProviderSanctionRepository $repository)
    {
    }

    public function __invoke(
        IdProvider $idProvider,
        string $action,
        DateTimeStart $dateStart,
        DateTimeEnd $dateEnd
    ): ProviderSanctionListerResponse {
        return new ProviderSanctionListerResponse($this->repository->find($idProvider, $action, $dateStart, $dateEnd));
    }
}
