<?php

namespace App\Modules\ProviderSanction\Application\Index;

use App\Modules\ProviderSanction\Domain\IdProviderSanction;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderSanctionIndexerQueryHandler implements QueryHandler
{
    public function __construct(private ProviderSanctionIndexer $inserter)
    {
    }

    public function __invoke(ProviderSanctionIndexerQuery $query): ProviderSanctionIndexerResponse
    {
        return $this->inserter->__invoke(new IdProviderSanction($query->getId()));
    }
}
