<?php

namespace App\Modules\Provider\Application\Index;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderIndexerQueryHandler implements QueryHandler
{
    public function __construct(private ProviderIndexer $inserter)
    {
    }

    public function __invoke(ProviderIndexerQuery $query): ProviderIndexerResponse
    {
        return $this->inserter->__invoke(new IdProvider($query->getId()));
    }
}
