<?php

namespace App\Modules\PaxInformationPassenger\Application\Insert;

use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassenger;

final class PaxInformationPassengerInsertConverter {

    public function __invoke(array $modelList): array {
        return array_map (
            fn($model) => new PaxInformationPassenger(
                $model->Id_PaxInformationPassenger,
                $model->PaxInformationPassenger_DateStart,
                $model->PaxInformationPassenger_DateEnd,
                $model->PaxInformationPassenger_Hour,
                $model->PaxInformationPassenger_Name,
                $model->PaxInformationPassenger_Origin,
                $model->PaxInformationPassenger_Destination,
                $model->PaxInformationPassenger_Type,
                $model->PaxInformationPassenger_TourDuration,
                $model->PaxInformationPassenger_Remark,
                $model->PaxInformationPassenger_MasterType,
                $model->PaxInformationPassenger_ServiceType,
                $model->PaxInformationPassenger_NotificationCount,
                $model->PaxInformationPassenger_NotificationStatus,
                $model->PaxInformationPassenger_Status,
                $model->Id_Service,
                $model->Service_Code,
                $model->Service_Name,
                $model->Service_Detail,
                $model->PaxInformationPassenger_NoPassenger,
                $model->PaxInformationPassenger_Provider_JSON
            ),
            $modelList['Response_Data']
        );
    }
}
