<?php

namespace App\Modules\PaxInformationPassenger\Application\Insert;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerInsert as DomainPaxInformationPassengerInsert;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRemaining;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRepository;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerStatus;

final class PaxInformationPassengerInsert
{
    private DomainPaxInformationPassengerInsert $finder;

    public function __construct(PaxInformationPassengerRepository $repository)
    {
        $this->finder = new DomainPaxInformationPassengerInsert($repository);
    }

    public function __invoke(
        PaxInformationPassengerRemaining $remaining,
        PaxInformationPassengerStatus $status,
        IdPaxInformation $idPaxInformation,
        IdPassenger $idPassenger
    ) {
        return $this->finder->__invoke($remaining, $status, $idPaxInformation, $idPassenger);
    }
}
