<?php

namespace App\Modules\PaxInformation\Application;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\PaxInformation\Domain\PaxInformationRepository;
use App\Modules\PaxInformation\Domain\IdPaxInformation;

class PaxInformationFinder {

    private PaxInformationRepository $repository;

    public function __construct(PaxInformationRepository $repository) {
        $this->repository = $repository;
    }

    public function __invoke (IdBooking $idBooking, string $action) {
        return $this->repository->find($idBooking, $action);
    }
}