<?php

namespace App\Modules\PaxInformation\Application\Insert;

use App\Modules\Shared\Domain\Bus\Command\Command;

final class PaxInformationInsertCommand implements Command
{
    public function __construct(
        private string $description,
        private int $remaining,
        private string $expire,
        private string $status,
        private int $idBooking,
        private int $idAdmin
    ) {
    }

    public function description(): string
    {
        return $this->description;
    }

    public function remaining(): int
    {
        return $this->remaining;
    }

    public function expire(): string
    {
        return $this->expire;
    }

    public function status(): string
    {
        return $this->status;
    }

    public function idBooking(): int
    {
        return $this->idBooking;
    }

    public function idAdmin(): int
    {
        return $this->idAdmin;
    }
}
