<?php

namespace App\Modules\PaxInformation\Application\Insert;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\PaxInformation\Domain\PaxInformationDateExpire;
use App\Modules\PaxInformation\Domain\PaxInformationDescription;
use App\Modules\PaxInformation\Domain\PaxInformationInsert as DomainPaxInformationInsert;
use App\Modules\PaxInformation\Domain\PaxInformationRemaining;
use App\Modules\PaxInformation\Domain\PaxInformationRepository;
use App\Modules\PaxInformation\Domain\PaxInformationStatus;

final class PaxInformationInsert
{
    private DomainPaxInformationInsert $finder;

    public function __construct(PaxInformationRepository $repository)
    {
        $this->finder = new DomainPaxInformationInsert($repository);
    }

    public function __invoke(
        PaxInformationDescription $description,
        PaxInformationRemaining $remaining,
        PaxInformationDateExpire $expire,
        PaxInformationStatus $status,
        IdBooking $idBooking,
        IdAdmin $idAdmin
    ) {
        return $this->finder->__invoke($description, $remaining, $expire, $status, $idBooking, $idAdmin);
    }
}
