<?php

namespace App\Modules\Passenger\Infraestructure;

class PassengerValidators
{

    public const UPDATE = [
        'Id_Passenger'          => 'required|int',
        'Passenger_Name'        => 'string|max:100',
        'Passenger_LastName'    => 'string|max:100',
        'Passenger_Email'       => 'string|max:250',
        'Passenger_PhoneCode'   => 'string|max:10',
        'Passenger_Phone'       => 'string|max:50',
        'Passenger_Gender'      => 'string|int',
        'Passenger_DOB'         => 'string|date',
        'Passenger_NoDocument'  => 'string|max:20',
        'Passenger_DateEntrance'=> 'string|date',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Passenger_Status'      => 'int',
        'Id_TypeDocument'       => 'int',
        'Id_UserCountry'        => 'int'
    ];

    public const UPDATE_REPORTABLE = [
        'Id_Passenger'          => 'required|int',
        'Passenger_Reportable'  => 'required|int',
    ];

    public const UPDATE_CONFIRM = [
        'Passenger_ConfirmMessage'  => 'string|max:500',
    ];

    public static function getUpdateDocuments($imageMimeType)
    {
        return [
            'Id_Passenger'              => 'required|int',
            'Passenger_ImgDocument1'    => 'image|mimes:' . $imageMimeType,
            'Passenger_ImgDocument2'    => 'image|mimes:' . $imageMimeType
        ];
    }

    public const REVIEW_REPORT_EXCEL = [
        'DateStart'     => 'required|string',
        'DateEnd'       => 'required|string',
        'Range'         => 'required|int',
        'Action'        => 'required|string',
    ];
}
