<?php

namespace App\Modules\Passenger\Application\UpdateReportable;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerReportable;
use App\Modules\Passenger\Domain\PassengerRepository;

final class PassengerReportableUpdater
{
    public function __construct(private PassengerRepository $repository)
    {
    }

    public function __invoke(IdPassenger $idPassenger, PassengerReportable $reportable): UpdatePassengerReportableResponse
    {
        return new UpdatePassengerReportableResponse($this->repository->updateReportable($idPassenger, $reportable));
    }
}
