<?php

namespace App\Modules\Passenger\Application\Remove;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class RemovePassengerQueryHandler implements QueryHandler
{
    public function __construct(private PassengerRemover $remover)
    {
    }

    public function __invoke(RemovePassengerQuery $query): RemovePassengerResponse
    {
        return $this->remover->__invoke(new IdPassenger($query->id()));
    }
}
