<?php

namespace App\Modules\Passenger\Application\GetServices;

use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class PassengerGetServicesQueryHandler implements QueryHandler
{
    public function __construct(
        private PassengerGetServicesQuery $inserter
    ) {
    }

    public function __invoke(PassengerGetServicesQuery $query): PassengerGetServicesResponse
    {
        return $this->inserter->__invoke(new IdProviderTypeProvider($query->getId()));
    }
}
