<?php

namespace App\Modules\Passenger\Application\Enable;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class EnablePassengerQueryHandler implements QueryHandler
{
    public function __construct(private PassengerEnabler $enabler)
    {
    }

    public function __invoke(EnablePassengerQuery $query): EnablePassengerResponse
    {
        return $this->enabler->__invoke(new IdPassenger($query->id()));
    }
}
