<?php

namespace App\Modules\Package\Application\GetCampSchedule;

use App\Modules\HtlCampSchedule\Application\List\ListHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\List\ListHtlCampScheduleResponses;
use App\Modules\Package\Application\GetCampSchedule\Package;
use App\Modules\Package\Application\GetCampSchedule\PackageTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;
use App\Modules\Shared\Domain\ValueObject\DateTimeValueObject;
use App\Modules\Shared\Domain\ValueObject\DateValueObject;
use App\Modules\TourHtlCamp\Application\TourHtlCampFinder;
use App\Modules\TourHtlCamp\Domain\THCIdTour;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use Illuminate\Support\Facades\DB;

class PackageCampScheduleGetter
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }
    public function __invoke(
        IdPackage $idPackage,
        DateStart $dateStart,
        DateEnd $dateEnd
    ) {
        $package = $this->indexPackage($idPackage);
        $package->packageTours = $this->listPackageTour($package, $dateStart, $dateEnd);
        $this->listHtlCamps($package, $dateStart, $dateEnd);
    }

    private function listHtlCamps(Package $package, $dateStart, $dateEnd)
    {
        foreach ($package->packageTours as $packageTour) {
            $packageTour->htlCamps = $this->listHtlCamp($packageTour, $dateStart, $dateEnd);
        }

        dd($package);
    }

    private function addDayToDateStart(DateStart $date, int $days)
    {
        $date = new DateTimeStart($date->value() . ' 00:00:00');
        $date->addInterval('P' . ($days - 1) . 'D');
        return $date;
    }

    private function addDayToDateEnd(DateEnd $date, int $days)
    {
        $date = new DateTimeEnd($date->value() . ' 23:59:59');
        $date->addInterval('P' . ($days - 1) . 'D');
        return $date;
    }

    private function indexPackage(IdPackage $idPackage)
    {
        return array_map(
            fn ($package) => new Package($package->Id_Package),
            DB::select('call sp_package_index(?)', [$idPackage->value()])
        )[0];
    }

    private function listPackageTour(Package $package, $dateStart, $dateEnd)
    {
        $day = 1;
        return array_map(
            function ($package) use (&$day, $dateStart, $dateEnd) {
                $packageTour = new PackageTour(
                    $package->Id_Tour,
                    $package->Tour_MinPax,
                    $package->Tour_Availability,
                    $package->Tour_AvailabilityStatus,
                    $day
                );
                $day = $day + $package->Tour_Duration;
                $dateTimeStart = $this->addDayToDateStart($dateStart, $packageTour->day);
                $dateTimeEnd = $this->addDayToDateEnd($dateEnd, $packageTour->day);
                $oParam = [
                    $package->Id_Tour,
                    $dateTimeStart->value(),
                    $dateTimeEnd->value()
                ];
                $packageTour->availability = DB::select('call sp_client_tour_availability_date(?,?,?)', $oParam);
                $packageTour->lockList = DB::select('call sp_tour_lock_list_date(?,?,?)', $oParam);
                $packageTour->generateSchedule($dateTimeStart, $dateTimeEnd);

                return $packageTour;
            },
            DB::select('call sp_package_tour_list(?)', [$package->idPackage])
        );
    }

    private function listHtlCamp(PackageTour $packageTour, $dateStart, $dateEnd)
    {
        return array_map(
            function ($tourHtlCamp) use ($packageTour, $dateStart, $dateEnd) {
                $tourCamp = new TourCamp(
                    $tourHtlCamp->Id_HtlCamp,
                    $tourHtlCamp->HtlCamp_Availability,
                    $tourHtlCamp->TourHtlCamp_Day + $packageTour->day - 1,
                );
                $dateTimeStart = $this->addDayToDateStart($dateStart, $tourCamp->day);
                $dateTimeEnd = $this->addDayToDateEnd($dateEnd, $tourCamp->day);
                $tourCamp->htlCampSchedules = $this->listHtlCampSchedule(
                    $tourCamp->idCamp,
                    $dateTimeStart,
                    $dateTimeEnd
                );
                $tourCamp->generateSchedule($dateTimeStart, $dateTimeEnd);
                dd($tourCamp->schedule);
                return $tourCamp;
            },
            $this->findHtlCamp($packageTour->idTour)
        );
    }

    private function findHtlCamp($idTour)
    {
        return (new TourHtlCampFinder(new MysqlTourHtlCampRepository))
            ->__invoke(new THCIdTour($idTour), 'active')['Response_Data'];
    }

    private function listHtlCampSchedule(
        int $idHtlCamp,
        DateTimeValueObject $dateStart,
        DateTimeValueObject $dateEnd
    ) {
        /** @var ListHtlCampScheduleResponses $response */
        $response = $this->queryBus->ask(new ListHtlCampScheduleQuery(
            $idHtlCamp,
            $dateStart->value(),
            $dateEnd->value()
        ));
        return array_map(
            function ($htlCampSchedule) {
                $htlCampSchedule->HtlCampSchedule_DateSchedule = date('Y-m-d', strtotime($htlCampSchedule->HtlCampSchedule_DateSchedule));
                return $htlCampSchedule;
            },
            $response->data()
        );
    }
}
