<?php

namespace App\Modules\Package\Application\GetCampSchedule;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class GetPackageCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(
        private PackageCampScheduleGetter $getter
    ) {
    }

    public function __invoke(GetPackageCampScheduleQuery $query)
    {
        $this->getter->__invoke(
            new IdPackage($query->getIdPackage()),
            new DateStart($query->getDateStart()),
            new DateEnd($query->getDateEnd())
        );
    }
}
