<?php

namespace App\Modules\Media\Infrastructure;

use App\Modules\Media\Domain\FileReceptor;
use App\Modules\Media\Domain\MediaType;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\File\File;

class LaravelFileReceptor implements FileReceptor
{

    public function __construct(
        private Request $request
    ) {
    }

    public function hasFile($inputName): bool
    {
        return $this->request->hasFile($inputName);
    }
    public function getExtension($inputName): string
    {
        return $this->request->file($inputName)->getClientOriginalExtension();
    }

    public function move($inputName, $directory, $name): File
    {
        return $this->request->file($inputName)->move($directory, $name);
    }

    public function getType($inputName): MediaType
    {
        $ext = $this->getExtension($inputName);
        if (in_array($ext, ['jpeg', 'jpg', 'png', 'HEIC', 'heic', 'RAW', 'raw', 'HEIF', 'heif'])) {
            return MediaType::image();
        }
        if (in_array($ext, ['mp4', 'mpeg', 'HEVC', 'hevc', 'MOV', 'mov'])) {
            return MediaType::video();
        }

        return null;
    }
}
